/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.contraptions.components.actor;

import com.nethersdelight.common.block.FungusColonyBlock;
import com.nethersdelight.core.registry.NDBlocks;
import com.nethersdelight.core.registry.NDItems;
import com.simibubi.create.content.contraptions.components.actors.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import plus.dragons.createcentralkitchen.content.contraptions.components.actor.HarvesterMovementBehaviourExtension;
import plus.dragons.createcentralkitchen.foundation.utility.ModLoadSubscriber;

@ModLoadSubscriber(modid="nethersdelight")
public class NDHarvesterMovementBehaviorExtensions {
    private static final BooleanProperty PEARL = BooleanProperty.m_61465_((String)"pearl");

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)NDBlocks.CRIMSON_FUNGUS_COLONY.get(), NDHarvesterMovementBehaviorExtensions::harvestFungusColony);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)NDBlocks.WARPED_FUNGUS_COLONY.get(), NDHarvesterMovementBehaviorExtensions::harvestFungusColony);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)NDBlocks.PROPELPLANT_BERRY_STEM.get(), NDHarvesterMovementBehaviorExtensions::harvestPropelplantStem);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)NDBlocks.PROPELPLANT_CANE.get(), NDHarvesterMovementBehaviorExtensions::harvestPropelplantCane);
            HarvesterMovementBehaviourExtension.REGISTRY.put((Block)NDBlocks.PROPELPLANT_BERRY_CANE.get(), NDHarvesterMovementBehaviorExtensions::harvestPropelplantCane);
        });
    }

    public static void harvestFungusColony(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        Block block = state.m_60734_();
        if (!(block instanceof FungusColonyBlock)) {
            return;
        }
        FungusColonyBlock colony = (FungusColonyBlock)block;
        IntegerProperty ageProp = colony.getAgeProperty();
        int age = (Integer)state.m_61143_((Property)ageProp);
        if (age <= 0) {
            return;
        }
        if (!partial && age < colony.getMaxAge()) {
            return;
        }
        Level level = context.world;
        if (partial && replant) {
            behaviour.dropItem(context, new ItemStack((ItemLike)colony.fungusType.get(), age));
            level.m_5594_(null, pos, SoundEvents.f_12075_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProp, (Comparable)Integer.valueOf(0)), 2);
        } else {
            BlockHelper.destroyBlock((Level)level, (BlockPos)pos, (float)1.0f, stack -> behaviour.dropItem(context, stack));
        }
    }

    public static void harvestPropelplantStem(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        Block block = state.m_60734_();
        Level level = context.world;
        if (((Boolean)state.m_61143_((Property)PEARL)).booleanValue()) {
            behaviour.dropItem(context, new ItemStack((ItemLike)NDItems.PROPELPEARL.get(), 1 + level.f_46441_.nextInt(2)));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.nextFloat() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PEARL, (Comparable)Boolean.FALSE), 2);
        }
    }

    public static void harvestPropelplantCane(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state, boolean replant, boolean partial) {
        BlockPos posBelow;
        BlockState stateBelow;
        Level level = context.world;
        BlockPos posAbove = pos.m_7494_();
        BlockState stateAbove = level.m_8055_(posAbove);
        if (stateAbove.m_60713_((Block)NDBlocks.PROPELPLANT_CANE.get()) || stateAbove.m_60713_((Block)NDBlocks.PROPELPLANT_BERRY_CANE.get())) {
            NDHarvesterMovementBehaviorExtensions.harvestPropelplantCane(behaviour, context, posAbove, stateAbove, false, partial);
        }
        if (state.m_61138_((Property)PEARL) && ((Boolean)state.m_61143_((Property)PEARL)).booleanValue()) {
            behaviour.dropItem(context, new ItemStack((ItemLike)NDItems.PROPELPEARL.get(), 1 + level.f_46441_.nextInt(2)));
            if (replant) {
                level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.nextFloat() * 0.4f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)PEARL, (Comparable)Boolean.FALSE), 2);
                return;
            }
        }
        BlockHelper.destroyBlock((Level)level, (BlockPos)pos, (float)1.0f, stack -> behaviour.dropItem(context, stack));
        if (replant && (stateBelow = level.m_8055_(posBelow = pos.m_7495_())).m_60713_((Block)NDBlocks.PROPELPLANT_STEM.get())) {
            level.m_46597_(posBelow, ((Block)NDBlocks.PROPELPLANT_BERRY_STEM.get()).m_49966_());
        }
    }
}

